import acm.program.*;

public class MammothDNA extends ConsoleProgram {
	
	private boolean couldContain(String mammothDna, String queryDna){
		int maxIndex = mammothDna.length() - queryDna.length(); 
		for (int i = 0; i <= maxIndex; i++) {
		    String mammothSub = mammothDna.substring(i);
		    if(couldStart(mammothSub, queryDna)) {
		        return true;
		    }
		}
		return false;
	} 
	
	private boolean couldStart(String m, String q) {
	    for(int i = 0; i < q.length(); i++) {
	        char mCh = m.charAt(i);
	        char qCh = q.charAt(i);
	        if(mCh != '?' && mCh != qCh) {
	            return false;
	        } 
	    }
	    return true;
	}

	/*************** STARTER CODE ************************/

	// You should not modify this method. You don't even need
	// to read it. It is here just for completeness.
	public void run() {
		while(true) {
			String mammoth = readLine("M: ");
			String query = readLine("Q: ");
			boolean result = couldContain(mammoth, query);
			println(result + "\n");
		}
	}
}